import express from "express";
import {
  createSignUp,
  getOneUser,
  forgetPassword,
  updatePassword,
  verifyEmail,
  updateEmail,
  userVerifyByEmail,
  updateIama
} from "#controllers/User.controller";
import validateObjectId from "#middlewares/validateObjectId";
import authMiddleware from "#middlewares/auth.middleware";


const userRoute = express.Router();

//Create Users
userRoute.route("/user").post(createSignUp)

//Forget Password
userRoute.post("/user/forget", forgetPassword);

//Get One User
userRoute.get("/user/:id", [authMiddleware], getOneUser);

//Verifed Email and Password Updated
userRoute.get("/user/verifed/", verifyEmail);

//Verify Email
userRoute.get("/user/verify/:id/:resetId/:email", verifyEmail);

//Verify Email
userRoute.get("/user/verifedUser/:id/:resetId/:email", userVerifyByEmail);

//Password Updated
userRoute.post("/user/update", updatePassword);

//update Email
userRoute.post("/user/updateEmail", [authMiddleware], updateEmail);
//update Role
userRoute.post("/user/updateLoginRole", [authMiddleware], updateIama);

export default userRoute;
