import express from "express";
import { createTask,getOneUserPerIncompleteTask, getAllTasks, getTaskById, updateTask, deleteTask } from "#controllers/Task.controller";

const taskRoute = express.Router();

// Task routes
taskRoute.post('/createTask', createTask);
taskRoute.get('/getUserIncompleteTask/:id', getOneUserPerIncompleteTask);
taskRoute.get('/getAllTasks', getAllTasks);
taskRoute.get('/tasks/:id', getTaskById);
taskRoute.put('/tasks/:id', updateTask);
taskRoute.delete('/tasks/:id', deleteTask);

export default taskRoute;