import mongoose from "mongoose";
import Joi from "joi";

const UserWalletSchema = new mongoose.Schema({
  userTelId: {
    type: String,
  },
  lastName: {
    type: String,
  },
  firstName: {
    type: String,
  },
  userName: {
    type: String,
  },
  userBalance: {
    type: Number,
    default:0
  },
  isVerified: {
    type: Boolean,
    default: false
  },
  isPremiumUser: {
    type: Boolean,
    default: false
  },
  isTwitterConnected: {
    type: Boolean,
    default: false
  },
  hasClaimedTwitterReward: {
    type: Boolean,
    default: false
  },
  hasClaimedYoutubeReward: {
    type: Boolean,
    default: false
  },
  isYoutubeSubscribe: {
    type: Boolean,
    default: false
  },
  lastLogin: {
    type: Date,
    default: Date.now,
  },
  userLevels: {
    type: Number,
    default:0
  },
  referral_target: {
    type: Number,
    default: 2
}
}, { timestamps: true });


function validateUserWallet(user) {
  const schema = Joi.object({
    userTelId: Joi.number().required(),
    lastName: Joi.string().required(),
    firstName: Joi.string().required(),
    userName: Joi.string().optional(),
    isPremiumUser: Joi.boolean().required()
  });
  return schema.validate(user);
}

function validateUserReward(user) {
  const schema = Joi.object({
    userTelId: Joi.number().required(),
    usrBalance: Joi.string().required()
  });
  return schema.validate(user);
}

function validateClaimReward(user) {
  const schema = Joi.object({
    userTelId: Joi.number().required()
  });
  return schema.validate(user);
}
const UserWallet = mongoose.model("UserWallet", UserWalletSchema);

export { UserWallet, validateUserWallet, validateUserReward, validateClaimReward};