import mongoose from "mongoose";
import Joi from "joi";
const UserVerificationSchema = new mongoose.Schema({
    email: {
        type: String,
    },
    resetId : {
        type: String,
    },
    createdAt: {
        type: Date,
        default: Date.now,
        index: { expires: 300 }
    },

});

function validateUserVerification(user) {
    const schema = Joi.object({
        resetId : Joi.string(),
        email: Joi.string()
        .required()
        .email()
    });
  
    return schema.validate(user);
  }
  
  const UserVerification = mongoose.model("UserVerification", UserVerificationSchema)

  export { UserVerification, validateUserVerification }