import mongoose from "mongoose";
import Joi from "joi";

const ReferralSchema  = new mongoose.Schema({
    referred_user: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true }, //joke refferal se aaya 
    referring_by: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true }, //jisne refferal kiya
}, { timestamps: true });


function validateUserReferral(user) {
  const schema = Joi.object({
    referred_user: Joi.number().required(),
    referring_by: Joi.string().required()
  });
  return schema.validate(user);
}


const Referral = mongoose.model("Referral", ReferralSchema);

export { Referral, validateUserReferral };